<?php
require_once __DIR__ . '/../../Config/functions.php';
require_login();

$rows = $data['rows'] ?? [];
$incomeTotal = $data['income_total'] ?? 0;
$expenseTotal = $data['expense_total'] ?? 0;
$netProfit = $data['net_profit'] ?? 0;
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Profit & Loss Statement | SGAccount</title>

<!-- AdminLTE & Fonts -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@5.15.4/css/all.min.css">

<!-- Custom Styles -->
<link rel="stylesheet" href="assets/css/custom.css">

<style>
.table td, .table th { vertical-align: middle; }
.text-right { text-align: right; }
.text-success { color: #28a745 !important; }
.text-danger { color: #dc3545 !important; }
</style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">

<?php include __DIR__ . '/../layouts/header.php'; ?>
<?php include __DIR__ . '/../layouts/sidebar.php'; ?>

<!-- =========================================================== -->
<!-- 🧾 MAIN CONTENT -->
<!-- =========================================================== -->
<div class="content-wrapper p-4">
  
  <!-- Toolbar -->
  <section class="content-header">
    <?php include __DIR__ . '/partials/toolbar.php'; ?>
  </section>

  <!-- Report Body -->
  <section class="content mt-3">
    <div class="card">
      <div class="card-body">
        <!-- Income Section -->
        <h4 class="mb-3"><strong>Income</strong></h4>
        <table class="table table-bordered table-striped">
          <thead class="bg-light">
            <tr>
              <th>Account</th>
              <th class="text-right">Amount (SGD)</th>
            </tr>
          </thead>
          <tbody>
            <?php
            $hasIncome = false;
            foreach ($rows as $r):
              if ($r['account_type'] === 'Income'):
                $hasIncome = true;
                $amount = $r['total_credit'] - $r['total_debit'];
            ?>
              <tr>
                <td><?= htmlspecialchars($r['account_name']) ?></td>
                <td class="text-right text-success"><?= number_format($amount, 2) ?></td>
              </tr>
            <?php
              endif;
            endforeach;
            if (!$hasIncome):
            ?>
              <tr><td colspan="2" class="text-center text-muted">No income records found.</td></tr>
            <?php endif; ?>
          </tbody>
          <tfoot class="bg-light font-weight-bold">
            <tr>
              <td>Total Income</td>
              <td class="text-right text-success"><?= number_format($incomeTotal, 2) ?></td>
            </tr>
          </tfoot>
        </table>

        <!-- Expense Section -->
        <h4 class="mt-4 mb-3"><strong>Expenses</strong></h4>
        <table class="table table-bordered table-striped">
          <thead class="bg-light">
            <tr>
              <th>Account</th>
              <th class="text-right">Amount (SGD)</th>
            </tr>
          </thead>
          <tbody>
            <?php
            $hasExpense = false;
            foreach ($rows as $r):
              if ($r['account_type'] === 'Expense'):
                $hasExpense = true;
                $amount = $r['total_debit'] - $r['total_credit'];
            ?>
              <tr>
                <td><?= htmlspecialchars($r['account_name']) ?></td>
                <td class="text-right text-danger"><?= number_format($amount, 2) ?></td>
              </tr>
            <?php
              endif;
            endforeach;
            if (!$hasExpense):
            ?>
              <tr><td colspan="2" class="text-center text-muted">No expense records found.</td></tr>
            <?php endif; ?>
          </tbody>
          <tfoot class="bg-light font-weight-bold">
            <tr>
              <td>Total Expenses</td>
              <td class="text-right text-danger"><?= number_format($expenseTotal, 2) ?></td>
            </tr>
          </tfoot>
        </table>

        <!-- Net Profit/Loss -->
        <div class="mt-4 p-3 bg-<?= $netProfit >= 0 ? 'success' : 'danger' ?> text-white rounded text-center">
          <h4 class="m-0">
            <?= $netProfit >= 0 ? 'Net Profit' : 'Net Loss' ?>:
            <?= number_format(abs($netProfit), 2) ?> SGD
          </h4>
        </div>
      </div>
    </div>
  </section>

</div>

<!-- Filter Modal -->
<?php include __DIR__ . '/modal-filter.php'; ?>

<?php include __DIR__ . '/../layouts/footer.php'; ?>

</div>

<!-- =========================================================== -->
<!-- 📜 SCRIPTS -->
<!-- =========================================================== -->
<script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>

<script>
$('#filterForm').on('submit', function(e){
  e.preventDefault();
  const s = $('input[name="start"]').val();
  const eDate = $('input[name="end"]').val();
  window.location = `router.php?page=profit-loss&start=${s}&end=${eDate}`;
});
</script>

</body>
</html>
