<?php
declare(strict_types=1);
require_once __DIR__ . '/../../../Config/config.php';
require_once __DIR__ . '/../../../Config/functions.php';
require_once __DIR__ . '/../../../Controllers/NotificationsController.php';

require_login();
header('Content-Type: application/json');

$controller = new NotificationsController();
$uid = (int)($_SESSION['user_id'] ?? 0);
$data = $controller->fetch($uid);

$count = count(array_filter($data, fn($n) => $n['is_read']==0));

echo json_encode([
    'count' => $count,
    'notifications' => $data
]);
