<?php
declare(strict_types=1);

/**
 * SGAccount Logout / Session Timeout Handler
 * Handles both manual logout and automatic session timeout.
 */

require_once __DIR__ . '/../../app/Config/config.php';
require_once __DIR__ . '/../../app/Controllers/AuthController.php';

// Initialize AuthController
$auth = new AuthController();

// Determine logout reason
$reason = $_GET['reason'] ?? 'logout';

// Perform logout cleanup
$auth->logout();

// Flash appropriate message
if ($reason === 'timeout') {
    set_flash('error', 'Your session has expired due to inactivity. Please sign in again.');
} else {
    set_flash('info', 'You have been logged out successfully.');
}

// Redirect back to login
header('Location: /router.php?page=login');
exit;
