<?php
declare(strict_types=1);

/**
 * SGAccount – Secure Login Page
 */

require_once __DIR__ . '/../Config/config.php'; // already loads functions.php
require_once __DIR__ . '/../Controllers/AuthController.php';

// Ensure session
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$auth = new AuthController();

// Auto-login via remember_me cookie
if ($auth->autoLogin()) {
    header('Location: router.php?page=dashboard');
    exit;
}

// Handle POST form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email    = post('email');
    $password = post('password');
    $remember = isset($_POST['remember']);
    $csrf     = post('csrf');

    if (!validate_csrf($csrf)) {
        set_flash('error', 'Security check failed. Please refresh the page.');
        header('Location: router.php?page=login');
        exit;
    }

    if ($auth->login($email, $password, $remember)) {
        set_flash('success', 'Welcome back!');
        header('Location: router.php?page=dashboard');
        exit;
    } else {
        set_flash('error', 'Invalid email or password.');
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Login | SGAccount</title>

  <!-- AdminLTE / Bootstrap / FontAwesome via CDN -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/toastr@2.1.4/build/toastr.min.css">
</head>

<body class="hold-transition login-page" style="background:#f4f6f9;">
<div class="login-box">
  <div class="login-logo">
    <img src="assets/img/logo.png" alt="Logo" width="60" class="mr-2">
    <b>SG</b>Account
  </div>

  <div class="card card-outline card-primary">
    <div class="card-body login-card-body">
      <p class="login-box-msg">Sign in to start your session</p>

      <form method="POST" action="">
        <!-- ✅ Dynamic CSRF token -->
        <input type="hidden" name="csrf" value="<?= csrf_token() ?>">

        <div class="input-group mb-3">
          <input type="email" name="email" class="form-control" placeholder="Email" required>
          <div class="input-group-append">
            <div class="input-group-text"><span class="fas fa-envelope"></span></div>
          </div>
        </div>

        <div class="input-group mb-3">
          <input type="password" name="password" class="form-control" placeholder="Password" required>
          <div class="input-group-append">
            <div class="input-group-text"><span class="fas fa-lock"></span></div>
          </div>
        </div>

        <div class="row">
          <div class="col-8">
            <div class="icheck-primary">
              <input type="checkbox" id="remember" name="remember">
              <label for="remember">Remember Me</label>
            </div>
          </div>
          <div class="col-4">
            <button type="submit" class="btn btn-primary btn-block">Sign In</button>
          </div>
        </div>
      </form>

      <p class="mb-1 mt-3 text-center">
        <a href="router.php?page=register-admin">Register Admin</a>
      </p>
    </div>
  </div>
</div>

<!-- JS Libraries -->
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/toastr@2.1.4/build/toastr.min.js"></script>

<!-- Toastr Flash Notifications -->
<script>
toastr.options = {
  "closeButton": true,
  "progressBar": true,
  "positionClass": "toast-top-right",
  "timeOut": "3500"
};

<?php if ($msg = get_flash('success')): ?>
toastr.success("<?= addslashes($msg) ?>");
<?php endif; ?>

<?php if ($msg = get_flash('error')): ?>
toastr.error("<?= addslashes($msg) ?>");
<?php endif; ?>
</script>

</body>
</html>
