<?php require_once __DIR__ . '/../../Config/functions.php'; require_login(); ?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Journal Details | SGAccount</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@5.15.4/css/all.min.css">
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">
<?php include __DIR__ . '/../layouts/header.php'; ?>
<?php include __DIR__ . '/../layouts/sidebar.php'; ?>

<div class="content-wrapper p-4">
  <h3><i class="fas fa-book mr-2"></i>Journal #<?= htmlspecialchars($journal['journal_no']) ?></h3>
  <p>Date: <?= htmlspecialchars($journal['journal_date']) ?> | Reference: <?= htmlspecialchars($journal['reference_no']) ?></p>
  <p><?= htmlspecialchars($journal['description']) ?></p>

  <div class="card mt-3">
    <div class="card-header d-flex justify-content-between align-items-center">
      <strong>Journal Line Items</strong>
      <button class="btn btn-success btn-sm" data-toggle="modal" data-target="#addLineModal"><i class="fas fa-plus"></i> Add Line</button>
    </div>
    <div class="card-body">
      <table class="table table-bordered" id="lineTable">
        <thead><tr><th>Account</th><th>Description</th><th>Debit</th><th>Credit</th><th></th></tr></thead>
        <tbody id="lineData"></tbody>
        <tfoot>
          <tr>
            <th colspan="2" class="text-right">Totals</th>
            <th id="totalDebit">0.00</th>
            <th id="totalCredit">0.00</th>
            <th></th>
          </tr>
        </tfoot>
      </table>
    </div>
  </div>
</div>

<div class="modal fade" id="addLineModal" tabindex="-1">
  <div class="modal-dialog">
    <div class="modal-content">
      <form id="addLineForm">
        <div class="modal-header bg-success text-white">
          <h5 class="modal-title">Add Line</h5>
          <button class="close text-white" data-dismiss="modal">&times;</button>
        </div>
        <div class="modal-body">
          <input type="hidden" name="journal_id" value="<?= $journal['id'] ?>">
          <div class="form-group"><label>Account Code</label>
            <input name="account_code" class="form-control" required>
          </div>
          <div class="form-group"><label>Description</label><input name="line_description" class="form-control"></div>
          <div class="form-row">
            <div class="form-group col-md-6"><label>Debit</label><input type="number" step="0.01" name="debit" value="0.00" class="form-control"></div>
            <div class="form-group col-md-6"><label>Credit</label><input type="number" step="0.01" name="credit" value="0.00" class="form-control"></div>
          </div>
        </div>
        <div class="modal-footer"><button type="submit" class="btn btn-success">Add</button></div>
      </form>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
function loadLines(){
  $.get('ajax/journal/fetch-lines.php',{journal_id:<?= $journal['id'] ?>},function(html){
    $('#lineData').html(html);
    calcTotals();
  });
}
function calcTotals(){
  let td=0, tc=0;
  $('#lineData tr').each(function(){
    td+=parseFloat($(this).find('.debit').text())||0;
    tc+=parseFloat($(this).find('.credit').text())||0;
  });
  $('#totalDebit').text(td.toFixed(2));
  $('#totalCredit').text(tc.toFixed(2));
}
$(function(){
  loadLines();
  $('#addLineForm').on('submit',function(e){
    e.preventDefault();
    $.post('ajax/journal/add-line.php',$(this).serialize(),function(){
      $('#addLineModal').modal('hide'); loadLines();
    });
  });
  $(document).on('click','.deleteLine',function(){
    $.post('ajax/journal/delete-line.php',{id:$(this).data('id')},function(){ loadLines(); });
  });
});
</script>
</body>
</html>
