<?php require_once __DIR__ . '/../../Config/functions.php'; require_login(); ?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>General Journal | SGAccount</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/datatables.net-bs4@1.13.4/css/dataTables.bootstrap4.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@5.15.4/css/all.min.css">
<!-- Custom CSS -->
<link rel="stylesheet" href="assets/css/custom.css">
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">
<?php include __DIR__ . '/../layouts/header.php'; ?>
<?php include __DIR__ . '/../layouts/sidebar.php'; ?>

<div class="content-wrapper p-4">
  <section class="content-header d-flex justify-content-between align-items-center">
    <h1><i class="fas fa-book mr-2"></i>General Journal</h1>
    <button class="btn btn-primary" data-toggle="modal" data-target="#addJournalModal"><i class="fas fa-plus"></i> Add Journal</button>
  </section>

  <section class="content mt-3">
    <div class="card">
      <div class="card-body">
        <table id="journalTable" class="table table-bordered table-striped">
          <thead><tr><th>No</th><th>Date</th><th>Description</th><th>Status</th><th>Action</th></tr></thead>
          <tbody>
            <?php foreach($journals as $j): ?>
            <tr>
              <td><?= htmlspecialchars($j['journal_no']) ?></td>
              <td><?= htmlspecialchars($j['journal_date']) ?></td>
              <td><?= htmlspecialchars($j['description']) ?></td>
              <td><span class="badge badge-<?= $j['status']=='posted'?'success':'secondary' ?>"><?= ucfirst($j['status']) ?></span></td>
              <td>
                <a href="router.php?page=journal-view&id=<?= $j['id'] ?>" class="btn btn-sm btn-info"><i class="fas fa-eye"></i></a>
                <button class="btn btn-sm btn-warning editJournal" data-id="<?= $j['id'] ?>"><i class="fas fa-edit"></i></button>
                <button class="btn btn-sm btn-danger deleteJournal" data-id="<?= $j['id'] ?>"><i class="fas fa-trash"></i></button>
              </td>
            </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </section>
</div>

<?php include __DIR__ . '/modal-add.php'; ?>
<?php include __DIR__ . '/modal-edit.php'; ?>
<?php include __DIR__ . '/../layouts/footer.php'; ?>

</div>
<script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/datatables.net@1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/datatables.net-bs4@1.13.4/js/dataTables.bootstrap4.min.js"></script>
<script>
$(function(){
  $('#journalTable').DataTable();

  $('#addJournalForm').on('submit', function(e){
    e.preventDefault();
    $.post('ajax/journal/add.php', $(this).serialize(), function(){ location.reload(); });
  });

  $('.deleteJournal').click(function(){
    if(confirm('Delete this journal?')) {
      $.post('ajax/journal/delete.php',{id:$(this).data('id')},function(){ location.reload(); });
    }
  });
});
</script>
</body>
</html>
