<?php
declare(strict_types=1);
require_once __DIR__ . '/../../Config/functions.php';
require_login();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>GST Detailed Report | SGAccount</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@5.15.4/css/all.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap4.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.bootstrap4.min.css">
<style>
  .table tfoot th {
    font-weight: bold;
    background: #f4f6f9;
  }
</style>
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">

<?php include __DIR__ . '/../layouts/header.php'; ?>
<?php include __DIR__ . '/../layouts/sidebar.php'; ?>

<div class="content-wrapper p-4">
  <section class="content-header d-flex justify-content-between align-items-center">
    <h1><i class="fas fa-file-invoice-dollar mr-2"></i> GST Detailed Report</h1>
    <a href="router.php?page=gst" class="btn btn-secondary"><i class="fas fa-arrow-left mr-1"></i> Back to Dashboard</a>
  </section>

  <!-- Filter -->
  <section class="content mt-3">
    <form method="get" action="router.php" class="form-inline mb-3">
      <input type="hidden" name="page" value="gst-reports">
      <label class="mr-2">Start:</label>
      <input type="date" name="start" value="<?= htmlspecialchars($_GET['start'] ?? date('Y-m-01')) ?>" class="form-control mr-3">
      <label class="mr-2">End:</label>
      <input type="date" name="end" value="<?= htmlspecialchars($_GET['end'] ?? date('Y-m-t')) ?>" class="form-control mr-3">
      <button class="btn btn-primary"><i class="fas fa-filter mr-1"></i> Apply</button>
    </form>

    <!-- Output GST (Sales) -->
    <div class="card">
      <div class="card-header bg-success text-white">
        <h3 class="card-title"><i class="fas fa-arrow-up mr-2"></i>Output GST (Sales)</h3>
      </div>
      <div class="card-body table-responsive">
        <table id="salesTable" class="table table-bordered table-striped table-sm">
          <thead>
            <tr>
              <th>Ref No</th>
              <th>Customer</th>
              <th>Date</th>
              <th class="text-right">Total (SGD)</th>
              <th class="text-right">GST Amount</th>
              <th class="text-center">Rate (%)</th>
            </tr>
          </thead>
          <tbody>
            <?php $totalSales = $totalGstSales = 0; ?>
            <?php foreach ($sales as $row): 
              $totalSales += $row['total_amount'];
              $totalGstSales += $row['gst_amount'];
            ?>
            <tr>
              <td><?= htmlspecialchars($row['ref_no']) ?></td>
              <td><?= htmlspecialchars($row['name'] ?? '-') ?></td>
              <td><?= htmlspecialchars($row['date']) ?></td>
              <td class="text-right"><?= number_format($row['total_amount'], 2) ?></td>
              <td class="text-right"><?= number_format($row['gst_amount'], 2) ?></td>
              <td class="text-center"><?= number_format($row['gst_rate'], 2) ?></td>
            </tr>
            <?php endforeach; ?>
          </tbody>
          <tfoot>
            <tr>
              <th colspan="3" class="text-right">Total Output:</th>
              <th class="text-right"><?= number_format($totalSales, 2) ?></th>
              <th class="text-right"><?= number_format($totalGstSales, 2) ?></th>
              <th></th>
            </tr>
          </tfoot>
        </table>
      </div>
    </div>

    <!-- Input GST (Purchases) -->
    <div class="card mt-4">
      <div class="card-header bg-danger text-white">
        <h3 class="card-title"><i class="fas fa-arrow-down mr-2"></i>Input GST (Purchases)</h3>
      </div>
      <div class="card-body table-responsive">
        <table id="purchaseTable" class="table table-bordered table-striped table-sm">
          <thead>
            <tr>
              <th>Ref No</th>
              <th>Vendor</th>
              <th>Date</th>
              <th class="text-right">Total (SGD)</th>
              <th class="text-right">GST Amount</th>
              <th class="text-center">Rate (%)</th>
            </tr>
          </thead>
          <tbody>
            <?php $totalPurch = $totalGstPurch = 0; ?>
            <?php foreach ($purchases as $row): 
              $totalPurch += $row['total_amount'];
              $totalGstPurch += $row['gst_amount'];
            ?>
            <tr>
              <td><?= htmlspecialchars($row['ref_no']) ?></td>
              <td><?= htmlspecialchars($row['name'] ?? '-') ?></td>
              <td><?= htmlspecialchars($row['date']) ?></td>
              <td class="text-right"><?= number_format($row['total_amount'], 2) ?></td>
              <td class="text-right"><?= number_format($row['gst_amount'], 2) ?></td>
              <td class="text-center"><?= number_format($row['gst_rate'], 2) ?></td>
            </tr>
            <?php endforeach; ?>
          </tbody>
          <tfoot>
            <tr>
              <th colspan="3" class="text-right">Total Input:</th>
              <th class="text-right"><?= number_format($totalPurch, 2) ?></th>
              <th class="text-right"><?= number_format($totalGstPurch, 2) ?></th>
              <th></th>
            </tr>
          </tfoot>
        </table>
      </div>
    </div>

    <!-- Net GST -->
    <div class="alert alert-info mt-4">
      <h5><i class="fas fa-balance-scale mr-2"></i>Net GST Summary (<?= htmlspecialchars($_GET['start'] ?? date('Y-m-01')) ?> → <?= htmlspecialchars($_GET['end'] ?? date('Y-m-t')) ?>)</h5>
      <p class="mb-0">
        <strong>Output GST:</strong> $<?= number_format($totalGstSales, 2) ?><br>
        <strong>Input GST:</strong> $<?= number_format($totalGstPurch, 2) ?><br>
        <strong>Net Payable / (Claimable):</strong> 
        <span class="badge badge-<?= ($totalGstSales - $totalGstPurch) >= 0 ? 'primary' : 'success' ?>">
          $<?= number_format($totalGstSales - $totalGstPurch, 2) ?>
        </span>
      </p>
    </div>
  </section>
</div>

<?php include __DIR__ . '/../layouts/footer.php'; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap4.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.bootstrap4.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script>
$(function(){
  $('#salesTable, #purchaseTable').DataTable({
    dom: 'Bfrtip',
    buttons: [
      { extend: 'csv', text: '<i class="fas fa-file-csv mr-1"></i> Export CSV', className: 'btn btn-outline-primary btn-sm' },
      { extend: 'excel', text: '<i class="fas fa-file-excel mr-1"></i> Export Excel', className: 'btn btn-outline-success btn-sm' }
    ],
    responsive: true,
    order: [[2, 'asc']]
  });
});
</script>
</body>
</html>
