<?php
/**
 * SGAccount – 404 Error Page
 * -------------------------------------------------------------
 * Professional AdminLTE 3.2 styled not-found page.
 * Safe to be used as a standalone fallback or inside router.
 */
declare(strict_types=1);

// Load essentials only if not already loaded
if (!function_exists('is_logged_in')) {
    require_once __DIR__ . '/../../Config/functions.php';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>404 Not Found | SGAccount</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@5.15.4/css/all.min.css">
<style>
body {
  background: #f4f6f9;
  font-family: 'Source Sans Pro', sans-serif;
}
.error-page {
  display: flex;
  align-items: center;
  justify-content: center;
  height: 100vh;
}
.error-content {
  text-align: center;
  max-width: 480px;
  background: #fff;
  border-radius: 12px;
  box-shadow: 0 0 20px rgba(0,0,0,0.08);
  padding: 40px 30px;
}
.error-content h1 {
  font-size: 5rem;
  color: #dc3545;
}
.error-content p {
  font-size: 1.1rem;
  color: #555;
}
.btn-primary {
  border-radius: 30px;
  padding: 8px 25px;
  font-weight: 500;
}
</style>
</head>

<body class="hold-transition">
<div class="error-page">
  <div class="error-content">
    <h1><i class="fas fa-exclamation-triangle"></i></h1>
    <h3>404 – Page Not Found</h3>
    <p class="mt-3">
      The page you are looking for doesn’t exist or has been moved.<br>
      You can return to the dashboard or contact your administrator.
    </p>
    <a href="router.php?page=dashboard" class="btn btn-primary mt-3">
      <i class="fas fa-home mr-2"></i>Return to Dashboard
    </a>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
