<?php
require_once __DIR__ . '/../../Config/functions.php';
require_login();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Dashboard | SGAccount</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@5.15.4/css/all.min.css">
<script src="https://cdn.jsdelivr.net/npm/chart.js@3.9.1/dist/chart.min.js"></script>

<!-- Custom CSS -->
<link rel="stylesheet" href="assets/css/custom.css">
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">

<?php include __DIR__ . '/../layouts/header.php'; ?>
<?php include __DIR__ . '/../layouts/sidebar.php'; ?>

<div class="content-wrapper p-4">
  <section class="content-header">
    <h1><i class="fas fa-chart-line mr-2"></i> Financial Dashboard</h1>
  </section>

  <section class="content mt-3">
    <div class="row">
      <!-- Net Profit -->
      <div class="col-lg-3 col-6">
        <div class="small-box bg-success">
          <div class="inner">
            <h3>$<?= number_format($summary['net_profit'],2) ?></h3>
            <p>Net Profit</p>
          </div>
          <div class="icon"><i class="fas fa-dollar-sign"></i></div>
        </div>
      </div>

      <!-- Cash Balance -->
      <div class="col-lg-3 col-6">
        <div class="small-box bg-info">
          <div class="inner">
            <h3>$<?= number_format($summary['cash'],2) ?></h3>
            <p>Cash Balance</p>
          </div>
          <div class="icon"><i class="fas fa-wallet"></i></div>
        </div>
      </div>

      <!-- Assets -->
      <div class="col-lg-3 col-6">
        <div class="small-box bg-primary">
          <div class="inner">
            <h3>$<?= number_format($summary['assets'],2) ?></h3>
            <p>Total Assets</p>
          </div>
          <div class="icon"><i class="fas fa-building"></i></div>
        </div>
      </div>

      <!-- Liabilities -->
      <div class="col-lg-3 col-6">
        <div class="small-box bg-danger">
          <div class="inner">
            <h3>$<?= number_format($summary['liabilities'],2) ?></h3>
            <p>Total Liabilities</p>
          </div>
          <div class="icon"><i class="fas fa-file-invoice-dollar"></i></div>
        </div>
      </div>
    </div>

    <!-- Charts -->
    <div class="row mt-4">
      <div class="col-md-6">
        <div class="card">
          <div class="card-header bg-secondary text-white">
            <h5 class="mb-0"><i class="fas fa-chart-bar mr-2"></i>Income vs Expenses Trend</h5>
          </div>
          <div class="card-body">
            <canvas id="trendChart" height="120"></canvas>
          </div>
        </div>
      </div>

      <div class="col-md-6">
        <div class="card">
          <div class="card-header bg-secondary text-white">
            <h5 class="mb-0"><i class="fas fa-balance-scale mr-2"></i>Assets vs Liabilities</h5>
          </div>
          <div class="card-body">
            <canvas id="balanceChart" height="120"></canvas>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>

<?php include __DIR__ . '/../layouts/footer.php'; ?>
</div>

<script>
const trendCtx = document.getElementById('trendChart').getContext('2d');
const trendData = {
  labels: <?= json_encode(array_column($trend,'month')) ?>,
  datasets: [
    {
      label: 'Income',
      backgroundColor: 'rgba(40,167,69,0.5)',
      borderColor: 'rgb(40,167,69)',
      data: <?= json_encode(array_column($trend,'income')) ?>,
      fill: true
    },
    {
      label: 'Expense',
      backgroundColor: 'rgba(220,53,69,0.5)',
      borderColor: 'rgb(220,53,69)',
      data: <?= json_encode(array_column($trend,'expense')) ?>,
      fill: true
    }
  ]
};
new Chart(trendCtx, { type: 'line', data: trendData, options: { responsive: true, plugins:{legend:{position:'top'}} } });

const balanceCtx = document.getElementById('balanceChart').getContext('2d');
new Chart(balanceCtx, {
  type: 'doughnut',
  data: {
    labels: ['Assets','Liabilities'],
    datasets: [{
      data: [<?= $summary['assets'] ?>, <?= $summary['liabilities'] ?>],
      backgroundColor: ['#007bff','#dc3545']
    }]
  },
  options: { responsive:true, plugins:{legend:{position:'bottom'}} }
});
</script>
</body>
</html>
