<?php require_once __DIR__ . '/../Config/functions.php'; require_login(); ?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Dashboard | SGAccount</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@5.15.4/css/all.min.css">
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
</head>

<body class="hold-transition sidebar-mini">
<div class="wrapper">

<?php include __DIR__ . '/layouts/header.php'; ?>
<?php include __DIR__ . '/layouts/sidebar.php'; ?>

<div class="content-wrapper p-4">
  <section class="content-header">
    <h1><i class="fas fa-tachometer-alt mr-2"></i>Financial Dashboard</h1>
  </section>

  <section class="content mt-3">
    <div class="row">
      <!-- KPI Cards -->
      <div class="col-md-3 col-sm-6">
        <div class="small-box bg-success">
          <div class="inner">
            <h3><?= number_format($income,2) ?></h3>
            <p>Total Income</p>
          </div>
          <div class="icon"><i class="fas fa-arrow-up"></i></div>
        </div>
      </div>
      <div class="col-md-3 col-sm-6">
        <div class="small-box bg-danger">
          <div class="inner">
            <h3><?= number_format($expense,2) ?></h3>
            <p>Total Expenses</p>
          </div>
          <div class="icon"><i class="fas fa-arrow-down"></i></div>
        </div>
      </div>
      <div class="col-md-3 col-sm-6">
        <div class="small-box bg-info">
          <div class="inner">
            <h3><?= number_format($cash,2) ?></h3>
            <p>Cash on Hand</p>
          </div>
          <div class="icon"><i class="fas fa-wallet"></i></div>
        </div>
      </div>
      <div class="col-md-3 col-sm-6">
        <div class="small-box <?= $net >= 0 ? 'bg-primary' : 'bg-warning' ?>">
          <div class="inner">
            <h3><?= number_format($net,2) ?></h3>
            <p><?= $net >= 0 ? 'Net Profit' : 'Net Loss' ?></p>
          </div>
          <div class="icon"><i class="fas fa-balance-scale"></i></div>
        </div>
      </div>
    </div>

    <!-- Charts -->
    <div class="row">
      <div class="col-md-6">
        <div class="card shadow-sm">
          <div class="card-header bg-primary text-white">
            <h5 class="mb-0"><i class="fas fa-chart-bar mr-2"></i>Income vs Expenses</h5>
          </div>
          <div class="card-body"><canvas id="chartIE" height="160"></canvas></div>
        </div>
      </div>
      <div class="col-md-6">
        <div class="card shadow-sm">
          <div class="card-header bg-success text-white">
            <h5 class="mb-0"><i class="fas fa-pie-chart mr-2"></i>Assets vs Liabilities</h5>
          </div>
          <div class="card-body"><canvas id="chartAL" height="160"></canvas></div>
        </div>
      </div>
    </div>
  </section>
</div>

<?php include __DIR__ . '/layouts/footer.php'; ?>

</div>

<script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
const ctx1 = document.getElementById('chartIE');
new Chart(ctx1, {
  type: 'bar',
  data: {
    labels: ['Income', 'Expenses'],
    datasets: [{
      label: 'Amount (SGD)',
      data: [<?= $income ?>, <?= $expense ?>],
      backgroundColor: ['#28a745','#dc3545']
    }]
  },
  options: {responsive:true,plugins:{legend:{display:false}}}
});

const ctx2 = document.getElementById('chartAL');
new Chart(ctx2, {
  type: 'doughnut',
  data: {
    labels: ['Assets', 'Liabilities'],
    datasets: [{
      data: [<?= $al['Asset'] ?? 0 ?>, <?= $al['Liability'] ?? 0 ?>],
      backgroundColor: ['#007bff','#ffc107']
    }]
  },
  options: {responsive:true,plugins:{legend:{position:'bottom'}}}
});
</script>
</body>
</html>
