<div class="modal fade" id="deleteCustomerModal" tabindex="-1" role="dialog" aria-labelledby="deleteCustomerModalLabel">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content border-danger">
      <div class="modal-header bg-danger text-white">
        <h5 class="modal-title"><i class="fas fa-trash-alt mr-2"></i> Confirm Delete</h5>
        <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
      </div>
      <div class="modal-body text-center">
        <p class="lead mb-3">Are you sure you want to delete this customer?</p>
        <strong id="deleteCustomerName" class="text-danger"></strong>
      </div>
      <div class="modal-footer justify-content-center">
        <input type="hidden" id="deleteCustomerId">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
        <button type="button" id="confirmDeleteBtn" class="btn btn-danger">Delete</button>
      </div>
    </div>
  </div>
</div>

<script>
function openDeleteModal(id, name) {
  $('#deleteCustomerId').val(id);
  $('#deleteCustomerName').text(name);
  $('#deleteCustomerModal').modal('show');
}

$('#confirmDeleteBtn').on('click', function() {
  const id = $('#deleteCustomerId').val();
  $.post('public/ajax/customers/delete.php', { id }, function(resp) {
    showToast(resp.message, resp.success ? 'success' : 'danger');
    if (resp.success) setTimeout(() => location.reload(), 1000);
  }, 'json');
});
</script>
