<div class="modal fade" id="addCustomerModal" tabindex="-1" role="dialog" aria-labelledby="addCustomerModalLabel">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <form id="addCustomerForm">
        <div class="modal-header bg-primary text-white">
          <h5 class="modal-title"><i class="fas fa-user-plus mr-2"></i> Add New Customer</h5>
          <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
        </div>
        <div class="modal-body">
          <div class="form-group">
            <label>Name</label>
            <input type="text" name="name" class="form-control" required>
          </div>

          <div class="form-group">
            <label>Email</label>
            <input type="email" name="email" class="form-control">
          </div>

          <div class="form-group">
            <label>Contact</label>
            <input type="text" name="contact" class="form-control">
          </div>

          <div class="form-group">
            <label>Status</label>
            <select name="status" class="form-control">
              <option value="active">Active</option>
              <option value="inactive">Inactive</option>
            </select>
          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Save</button>
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
function openEditModal(customer) {
  $('#edit_customer_id').val(customer.id);
  $('#edit_name').val(customer.name);
  $('#edit_email').val(customer.email);
  $('#edit_contact').val(customer.contact);
  $('#edit_status').val(customer.status);
  $('#editCustomerModal').modal('show');
}

$('#addCustomerForm').on('submit', function(e) {
  e.preventDefault();
  $.post('public/ajax/customers/add.php', $(this).serialize(), function(resp) {
    alert(resp.message);
    if (resp.success) location.reload();
  }, 'json');
});
</script>
