<div class="modal fade" id="editCoaModal" tabindex="-1" role="dialog" aria-labelledby="editCoaLabel">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <form id="editCoaForm">
        <div class="modal-header bg-info text-white">
          <h5 class="modal-title"><i class="fas fa-edit mr-2"></i> Edit Account</h5>
          <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
        </div>
        <div class="modal-body">
          <input type="hidden" name="id" id="edit_id">
          <div class="form-group">
            <label>Account Code</label>
            <input type="text" name="account_code" id="edit_code" class="form-control" required>
          </div>
          <div class="form-group">
            <label>Account Name</label>
            <input type="text" name="account_name" id="edit_name" class="form-control" required>
          </div>
          <div class="form-group">
            <label>Account Type</label>
            <select name="account_type" id="edit_type" class="form-control" required>
              <option>Asset</option><option>Liability</option><option>Equity</option>
              <option>Income</option><option>Expense</option>
            </select>
          </div>
          <div class="form-group">
            <label>Description</label>
            <textarea name="description" id="edit_desc" class="form-control" rows="2"></textarea>
          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-info">Update</button>
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
function openEditModal(acc) {
  $('#edit_id').val(acc.id);
  $('#edit_code').val(acc.account_code);
  $('#edit_name').val(acc.account_name);
  $('#edit_type').val(acc.account_type);
  $('#edit_desc').val(acc.description);
  $('#editCoaModal').modal('show');
}

$('#editCoaForm').on('submit', function(e){
  e.preventDefault();
  $.post('public/ajax/coa/edit.php', $(this).serialize(), function(resp){
    showToast(resp.message, resp.success ? 'success' : 'danger');
    if (resp.success) setTimeout(() => location.reload(), 1000);
  }, 'json');
});
</script>
