<?php require_once __DIR__ . '/../../Config/functions.php'; require_login(); ?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Invoice <?= htmlspecialchars($invoice['invoice_no']) ?> | SGAccount</title>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
<style>
@media print {.no-print{display:none;} body{font-size:13px;}}
</style>
</head>
<body>
<div class="container mt-4">
  <div class="row mb-3">
    <div class="col-8">
      <h4><strong>SGAccount Pte Ltd</strong></h4>
      <p>123 Home Renovation Rd<br>Singapore 123456</p>
    </div>
    <div class="col-4 text-right">
      <h5>Invoice #: <?= htmlspecialchars($invoice['invoice_no']) ?></h5>
      <p>Date: <?= htmlspecialchars($invoice['invoice_date']) ?><br>Due: <?= htmlspecialchars($invoice['due_date']) ?></p>
    </div>
  </div>
  <hr>
  <div class="row mb-3">
    <div class="col-6">
      <h6><strong>Bill To:</strong></h6>
      <p><?= htmlspecialchars($invoice['customer_name']) ?><br><?= nl2br(htmlspecialchars($invoice['address'])) ?><br>
      <?= htmlspecialchars($invoice['email']) ?> | <?= htmlspecialchars($invoice['contact_no']) ?></p>
    </div>
  </div>
  <table class="table table-bordered">
    <thead class="bg-light"><tr><th>Description</th><th class="text-right">Qty</th><th class="text-right">Unit</th><th class="text-right">Total</th></tr></thead>
    <tbody>
      <?php foreach($items as $it): ?>
      <tr>
        <td><?= htmlspecialchars($it['item_description']) ?></td>
        <td class="text-right"><?= $it['quantity'] ?></td>
        <td class="text-right"><?= number_format($it['unit_price'],2) ?></td>
        <td class="text-right"><?= number_format($it['line_total'],2) ?></td>
      </tr>
      <?php endforeach; ?>
    </tbody>
    <tfoot>
      <tr><td colspan="3" class="text-right"><strong>Subtotal</strong></td><td class="text-right"><?= number_format($invoice['subtotal'],2) ?></td></tr>
      <tr><td colspan="3" class="text-right"><strong>GST</strong></td><td class="text-right"><?= number_format($invoice['gst'],2) ?></td></tr>
      <tr><td colspan="3" class="text-right"><strong>Total</strong></td><td class="text-right"><?= number_format($invoice['total_amount'],2) ?></td></tr>
    </tfoot>
  </table>
  <p><strong>Status:</strong> <?= ucfirst($invoice['status']) ?></p>
  <div class="no-print mt-3">
    <button onclick="window.print()" class="btn btn-primary"><i class
