<!-- Bill Edit Modal -->
<div class="modal fade" id="editBillModal" tabindex="-1" aria-labelledby="editBillLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-warning text-white">
        <h5 class="modal-title"><i class="fas fa-edit mr-2"></i>Edit Bill</h5>
        <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
      </div>
      <form id="editBillForm">
        <input type="hidden" name="id" id="editBillId">
        <div class="modal-body">
          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                <label>Bill No</label>
                <input type="text" name="bill_no" id="editBillNo" class="form-control" required>
              </div>
              <div class="form-group">
                <label>Vendor</label>
                <select name="vendor_id" id="editVendorId" class="form-control" required>
                  <option value="">Select Vendor</option>
                  <?php foreach($vendors as $v): ?>
                    <option value="<?= $v['id'] ?>"><?= htmlspecialchars($v['name']) ?></option>
                  <?php endforeach; ?>
                </select>
              </div>
              <div class="form-group">
                <label>Bill Date</label>
                <input type="date" name="bill_date" id="editBillDate" class="form-control" required>
              </div>
              <div class="form-group">
                <label>Due Date</label>
                <input type="date" name="due_date" id="editDueDate" class="form-control">
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group">
                <label>Total Amount (SGD)</label>
                <input type="number" step="0.01" name="total_amount" id="editTotalAmount" class="form-control" required>
              </div>
              <div class="form-group">
                <label>GST Amount (SGD)</label>
                <input type="number" step="0.01" name="gst_amount" id="editGstAmount" class="form-control">
              </div>
              <div class="form-group">
                <label>Remarks</label>
                <textarea name="remarks" id="editRemarks" rows="3" class="form-control"></textarea>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer bg-light">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-warning"><i class="fas fa-save mr-1"></i>Update Bill</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
function loadBillToEdit(bill) {
  $('#editBillId').val(bill.id);
  $('#editBillNo').val(bill.bill_no);
  $('#editVendorId').val(bill.vendor_id);
  $('#editBillDate').val(bill.bill_date);
  $('#editDueDate').val(bill.due_date);
  $('#editTotalAmount').val(bill.total_amount);
  $('#editGstAmount').val(bill.gst_amount);
  $('#editRemarks').val(bill.remarks);
}

$('#editBillForm').on('submit', function(e){
  e.preventDefault();
  $.post('public/ajax/ap/bill-edit.php', $(this).serialize(), function(){
    $('#editBillModal').modal('hide');
    location.reload();
  });
});
</script>
