<!-- Bill Add Modal -->
<div class="modal fade" id="addBillModal" tabindex="-1" aria-labelledby="addBillLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title"><i class="fas fa-plus-circle mr-2"></i>Add New Bill</h5>
        <button type="button" class="close text-white" data-dismiss="modal">&times;</button>
      </div>
      <form id="addBillForm">
        <div class="modal-body">
          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                <label>Bill No</label>
                <input type="text" name="bill_no" class="form-control" required>
              </div>
              <div class="form-group">
                <label>Vendor</label>
                <select name="vendor_id" class="form-control" required>
                  <option value="">Select Vendor</option>
                  <?php foreach($vendors as $v): ?>
                    <option value="<?= $v['id'] ?>"><?= htmlspecialchars($v['name']) ?></option>
                  <?php endforeach; ?>
                </select>
              </div>
              <div class="form-group">
                <label>Bill Date</label>
                <input type="date" name="bill_date" class="form-control" required>
              </div>
              <div class="form-group">
                <label>Due Date</label>
                <input type="date" name="due_date" class="form-control">
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group">
                <label>Total Amount (SGD)</label>
                <input type="number" step="0.01" name="total_amount" class="form-control" required>
              </div>
              <div class="form-group">
                <label>GST Amount (SGD)</label>
                <input type="number" step="0.01" name="gst_amount" class="form-control">
              </div>
              <div class="form-group">
                <label>Remarks</label>
                <textarea name="remarks" rows="3" class="form-control"></textarea>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer bg-light">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-primary"><i class="fas fa-save mr-1"></i>Save Bill</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
$('#addBillForm').on('submit', function(e){
  e.preventDefault();
  $.post('public/ajax/ap/bill-add.php', $(this).serialize(), function(){
    $('#addBillModal').modal('hide');
    location.reload();
  });
});
</script>
