<?php
require_once __DIR__ . '/../../vendor/autoload.php';
require_once __DIR__ . '/../Controllers/ReportsController.php';
use FPDF\FPDF;

$controller = new ReportsController();
$data = $controller->cashFlow();

$pdf = new FPDF();
$pdf->AddPage();
$pdf->SetFont('Arial','B',14);
$pdf->Cell(0,10,'Cash Flow Statement',0,1,'C');
$pdf->Ln(10);

$pdf->SetFont('Arial','',11);
foreach($data as $k=>$v){
    $pdf->Cell(100,8,$k,1);
    $pdf->Cell(80,8,number_format($v,2),1,1,'R');
}
$pdf->Ln(5);
$total = array_sum($data);
$pdf->SetFont('Arial','B',11);
$pdf->Cell(100,8,'Net Cash Flow',1);
$pdf->Cell(80,8,number_format($total,2),1,1,'R');

$pdf->Output('I','Cash_Flow_'.date('Ymd').'.pdf');
exit;
