<?php
declare(strict_types=1);
require_once __DIR__ . '/../Config/database.php';

class Settings {
    private PDO $db;
    public function __construct() { $this->db = Database::getConnection(); }

    public function get(): ?array {
        return $this->db->query("SELECT * FROM system_settings LIMIT 1")->fetch();
    }

    public function update(array $data): bool {
        $stmt = $this->db->prepare("
            UPDATE system_settings SET 
            timezone=:timezone, date_format=:date_format, 
            dark_mode=:dark_mode, auto_backup=:auto_backup, 
            updated_at=NOW() WHERE id=:id");
        return $stmt->execute($data);
    }
}
