<?php
declare(strict_types=1);
require_once __DIR__ . '/../../app/Models/Gst.php';
require_once __DIR__ . '/../../app/Config/functions.php';

class GstController {
    public function index(): void {
        require_login();
        $model = new Gst();
        $periodStart = $_GET['start'] ?? date('Y-m-01');
        $periodEnd   = $_GET['end']   ?? date('Y-m-t');
        $summary     = $model->getSummary($periodStart, $periodEnd);
        $history     = $model->getHistory();
        include __DIR__ . '/../../app/Views/gst/index.php';
    }

    public function reports(): void {
        require_login();
        $model = new Gst();
        $start = $_GET['start'] ?? date('Y-m-01');
        $end   = $_GET['end']   ?? date('Y-m-t');
        $sales = $model->getTransactions($start, $end, 'sales');
        $purchases = $model->getTransactions($start, $end, 'purchases');
        include __DIR__ . '/../../app/Views/gst/reports.php';
    }
}
