<?php
declare(strict_types=1);

require_once __DIR__ . '/../../app/Models/Dashboard.php';
require_once __DIR__ . '/../../app/Config/functions.php';

/**
 * DashboardController
 * -------------------------------------------------------------
 * Controls the main financial dashboard display for SGAccount.
 * Fetches summary and trend data from the Dashboard model
 * and loads the main view.
 * -------------------------------------------------------------
 */
class DashboardController
{
    /**
     * Display the Financial Dashboard.
     */
    public function index(): void
    {
        // ✅ Ensure user authentication
        require_login();

        // ✅ Load dashboard data
        $model   = new Dashboard();
        $summary = $model->getSummary();        // Income, Expenses, Cash, etc.
        $trend   = $model->getMonthlyTrend();   // Monthly chart data

        // ✅ Render the dashboard view
        include __DIR__ . '/../../app/Views/dashboard/index.php';
    }
}
