<?php
declare(strict_types=1);

require_once __DIR__ . '/../Config/config.php';
require_once __DIR__ . '/../Config/database.php';
require_once __DIR__ . '/../Models/Company.php';
require_once __DIR__ . '/../Config/functions.php';

class CompanyController
{
    private Company $model;

    public function __construct()
    {
        $pdo = Database::getConnection();
        $this->model = new Company($pdo);
    }

    /**
     * Display all company records
     */
    public function index(): void
    {
        require_login();
        $companies = $this->model->getAll();
        include __DIR__ . '/../Views/company/index.php';
    }

    /**
     * View a single company profile
     */
    public function view(): void
    {
        require_login();

        $id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
        $company = $this->model->find($id);

        if (!$company) {
            http_response_code(404);
            include __DIR__ . '/../Views/errors/404.php';
            return;
        }

        include __DIR__ . '/../Views/company/view.php';
    }
}
