<?php
declare(strict_types=1);
require_once __DIR__ . '/../../app/Models/Bank.php';
require_once __DIR__ . '/../../app/Config/functions.php';

class BankController {
    public function index(): void {
        require_login();
        $model = new Bank();
        $accounts = $model->getAccounts();

        // Optional: get transactions for first account
        $selectedId = $_GET['id'] ?? ($accounts[0]['id'] ?? null);
        $transactions = $selectedId ? $model->getTransactions((int)$selectedId) : [];

        include __DIR__ . '/../../app/Views/bank/index.php';
    }
}
