<?php
declare(strict_types=1);
require_once __DIR__ . '/../../app/Models/Ar.php';
require_once __DIR__ . '/../../app/Config/functions.php';

class ArController {
    public function index(): void {
        require_login();
        $model = new Ar();
        $invoices = $model->getAll(); // ← This line must exist
        $title = "Accounts Receivable";
        include __DIR__ . '/../../app/Views/ar/index.php';
    }

    public function view(int $id): void {
        require_login();
        $model = new Ar();
        $invoice = $model->getById($id);
        include __DIR__ . '/../../app/Views/ar/view.php';
    }
}
